<?php

$developersObj = new developers();


class developers 
{

    var $mDb;
    var $mConfig;
    // var $notificate;

    function __construct()
    {
        global $Config;
        $this->mDb = new iplus();
        $this->mConfig = $Config;
        //    $this->notificate = new pushmessage();
    }

    function convert_object_to_array($data)
    {

        // print_r($data);die();
        if (is_object($data)) {
            $data = get_object_vars($data);
        }

        if (is_array($data)) {
            return array_map(__METHOD__, $data);
        } else {
            return $data;
        }
    }


   
    function getAlldevelopers($name = null, $start = 0, $itemsPerPage = 10, $sort = 'c.date_added', $type = 'ASC')
    {
        try {
            $db = $this->mDb->connect();
   
            // Validate sort column and type to prevent SQL injection
            $allowedSortColumns = ['c.id', 'c.status', 'c.date_added', 'u.full_name', 'cl.name'];
            $allowedSortTypes = ['ASC', 'DESC'];
    
            if (!in_array($sort, $allowedSortColumns)) {
                $sort = 'c.date_added';
            }
            if (!in_array(strtoupper($type), $allowedSortTypes)) {
                $type = 'ASC';
            }
    
            // Base SQL query
            $sql = "
                SELECT SQL_CALC_FOUND_ROWS 
                    c.id, c.status, c.date_added, c.added_by,c.img,
                    u.full_name, cl.name 
                FROM developers_management c
                LEFT JOIN users u ON c.added_by = u.id
                LEFT JOIN developers_management_langs cl ON c.id = cl.company_id AND cl.lang_code = :lang_code
                WHERE c.is_deleted = '0'
            ";
    
            // Add name filter if provided
            if ($name) {
                $sql .= " AND cl.name LIKE :name";
            }
    
            // Add sorting and pagination
            $sql .= " ORDER BY $sort $type LIMIT :start, :limit";
    
            // Prepare the query
                $stmt = $db->prepare($sql);
            $lang_code = LANGUAGE;
            $stmt->bindParam(':lang_code', $lang_code);
            // Bind parameters
            if ($name) {
                $stmt->bindValue(':name', '%' . $name . '%', PDO::PARAM_STR);
            }
            $stmt->bindValue(':start', (int)$start, PDO::PARAM_INT);
            $stmt->bindValue(':limit', (int)$itemsPerPage, PDO::PARAM_INT);
    
            // Execute the query
            $stmt->execute();
    
            // Fetch the results
            $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
      
            // Fetch the total row count
            $totalQuery = $db->query("SELECT FOUND_ROWS() as total");
            $total = $totalQuery->fetch(PDO::FETCH_ASSOC)['total'];
            
    
            return [
                'status' => 200,
                'data' => $data,
                'count' => $total,
                'success' => true
            ];
        } catch (PDOException $e) {
            // Handle and log errors
            return [
                'status' => 500,
                'error' => $e->getMessage(),
                'success' => false
            ];
        }
    }
    

    /////////////////////////////////////// Admins ///////////////////////////////////////////////

    function addEditdevelopers($request)
    {
            // print_r($request);die();
        $dateTime = date('Y-m-d H:i:s');
        $db = $this->mDb->connect();
        $langs = json_decode($request['langs'], true);
        global $USER_DATA;
    
        try {
            if (empty($request['id']) ||!isset($request['id'])) {
             
                // Insert into `cities` table
                $sql = "INSERT INTO developers_management SET
                status = :status,
                 added_by =:added_by,
                 date_added =:date_added
                 ";
                 if (isset($request['img']))
                 $sql.= ", img = :img ";
                 $stmt = $db->prepare($sql);

                $stmt->bindParam(':status',$request['status']);
                $stmt->bindParam(':added_by',$request['user_id']);
                $stmt->bindParam(':date_added',$dateTime);
                if (isset($request['img']))
                $stmt->bindParam(':img',$request['img']);
                $stmt->execute();
            
                // Get the last inserted ID
                $last_id = $db->lastInsertId();
               
           
                // Insert into `city_langs` table
                if (!empty($langs)) {
                    $sqlForLang = "INSERT INTO developers_management_langs (lang_code, name,company_id) VALUES (:lang_code, :name, :company_id)";

                    $stmtForLang = $db->prepare($sqlForLang);
    
                    foreach ($langs as $row) {
                        $stmtForLang->execute([
                            ':lang_code' => $row['lang_code'],
                            ':name' => $row['name'],
                            ':company_id' => $last_id
                        ]);
                    }
                }
    
                return [
                    'status' => 200,
                    'data' => 'Added successfully',
                    'success' => true
                ];
            } else {
                // Update `cities_management` table
                if (isset($request['status'])) {
                    $sql = "UPDATE developers_management SET status = :status WHERE id = :id";
                    $stmt = $db->prepare($sql);
                    $stmt->execute([
                        ':status' => $request['status'],
                        ':id' => $request['id']
                    ]);
                }
    
                // Update `city_langs` table
                if (!empty($langs)) {
                    $sqlForLangs = "UPDATE developers_management_langs SET name = :name WHERE company_id = :company_id AND lang_code = :lang_code";
                    $stmtForLangs = $db->prepare($sqlForLangs);
    
                    foreach ($langs as $row) {
                        $stmtForLangs->execute([
                            ':company_id' => $request['id'],
                            ':lang_code' => $row['lang_code'],
                            ':name' => $row['name']
                        ]);
                    }
                }
    
                return [
                    'status' => 200,
                    'data' => 'Updated successfully',
                    'success' => true
                ];
            }
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'error' => $e->getMessage(),
                'success' => false
            ];
        }
    
        return [
            'status' => 0,
            'data' => null,
            'success' => false
        ];
    }
    

    public function deletedeveloper($ids)
    {
        // Check if $ids is empty
        if (empty($ids) || !is_array($ids)) {
            return [
                'status' => 400,
                'success' => false,
                'data' => "No city IDs provided or invalid input"
            ];
        }
    
        try {
            // Convert $ids array into a comma-separated string of placeholders
            $placeholders = implode(',', array_fill(0, count($ids), '?'));
    
            // Prepare the SQL query
            $usersql = "UPDATE `developers_management` 
                        SET `is_deleted` = '1'
                        WHERE `id` IN ($placeholders)";
            $stmt = $this->mDb->connect()->prepare($usersql);
    
            // Execute the statement with $ids as the bound parameters
            $stmt->execute($ids);
    
            // Get the number of rows affected
            $deletedCount = $stmt->rowCount();
    
            if ($deletedCount === 0) {
                return [
                    'status' => 404,
                    'success' => false,
                    'data' => "No Deletion Occurred"
                ];
            }
    
            return [
                'status' => 200,
                'success' => true,
                'data' => "$deletedCount Items Deleted Successfully"
            ];
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'success' => false,
                'data' => "An Error Occurred: " . $e->getMessage()
            ];
        }
    }
    

  


    function getdeveloperInfo($id)
    {
        try {
            // SQL query to fetch city info and related languages
            $sql = "
                SELECT c.id, c.date_added,c.img, c.status, cl.name
                FROM developers_management c
                LEFT JOIN developers_management_langs cl ON c.id = cl.company_id
                WHERE c.is_deleted = '0' AND c.id = :id
            ";
    
            $stmt = $this->mDb->connect()->prepare($sql);
            $stmt->bindParam(':id', $id);
            $stmt->execute();
    
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC); // Fetch all rows
    
            // Prepare the response
            if ($result) {
                // Assuming we want to collect languages in an array
                $langs = [];
                $cityData = [
                    'id' => $result[0]['id'],
                    'img'=>$result[0]['img'],
                    'date_added' => $result[0]['date_added'],
                    'status' => $result[0]['status'],
                ];
    
                foreach ($result as $row) {
                    $langs[] = [
                        'name' => $row['name'],
                        // 'city_id' => $row['city_id'],
                    ];
                }
    
                return [
                    'status' => 200,
                    'success' => true,
                    'data' => array_merge($cityData, ['langs' => $langs]),
                ];
            } else {
                return [
                    'status' => 404,
                    'success' => false,
                    'data' => 'City not found',
                ];
            }
    
        } catch (PDOException $e) {
            return [
                'status' => 500,
                'success' => false,
                'data' => 'An error occurred: ' . $e->getMessage(),
            ];
        }
    }
    

  


  



   
    
    


    
   
  
    
  
  












  
  
  

  
 

}