<?php

$closingDealsMangmentOBJ = new closingDealsMangment();

class closingDealsMangment
{

	var $mDb;
	var $mConfig;
	var $mlang;

	function __construct()
	{
		global $Config;
		global $Lang;
		$this->mDb = new iplus();
		$this->mConfig = $Config;
		$this->mlang = $Lang;
	}


	function convert_object_to_array($data)
	{
        
		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(__METHOD__, $data);
		} else {
			return $data;
		}
	}
    function getALLlosingDeals($aStart, $aLimit, $sort, $type, $searchTitle) {
        $lang_code = LANGUAGE;
        $db = $this->mDb->connect();
    
        // التحقق من القيم المدخلة للفرز والتصنيف
        $allowedSortColumns = ['id', 'status', 'name']; // أعمدة مسموح بالفرز بها
        $sort = in_array($sort, $allowedSortColumns) ? $sort : 'id'; // العمود الافتراضي
        $type = strtoupper($type) === 'DESC' ? 'DESC' : 'ASC'; // النوع الافتراضي
    
        // كتابة الاستعلام
        $sql = "SELECT SQL_CALC_FOUND_ROWS c.id, c.status,c.date_added, dl.name AS developer_name, 
                       pl.name AS project_name, u.full_name as added_by,u.phone as added_by_phone 
                FROM closing_deals_management c
                LEFT JOIN developers_management_langs dl ON dl.company_id = c.company_id AND dl.lang_code = :lang_code 
                LEFT JOIN projects_management_langs pl ON c.project_id = pl.project_id AND pl.lang_code = :lang_code 
                LEFT JOIN users u ON c.added_by = u.id 
                WHERE c.is_deleted = '0'";
    
        // إضافة ترتيب وتحديد النتائج
        $sql .= " ORDER BY $sort $type LIMIT :start, :limit";
     
        // تحضير وتنفيذ الاستعلام
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':lang_code', $lang_code, PDO::PARAM_STR);
        $stmt->bindParam(':start', $aStart, PDO::PARAM_INT);
        $stmt->bindParam(':limit', $aLimit, PDO::PARAM_INT);
        $stmt->execute();
    
        // الحصول على النتائج
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        // الحصول على العدد الإجمالي
        $totalQuery = $db->query("SELECT FOUND_ROWS() as total");
        $total = $totalQuery->fetch(PDO::FETCH_ASSOC)['total'];
    
        // إرجاع البيانات
        return [
            'status' => 200,
            'data' => $data,
            'count' => $total,
            'success' => true
        ];
    }
    
    


function getOneClosingDeals($id) {
   $lang_code =LANGUAGE;
  
   $sql = "SELECT c.unit_id,c.unit_number,c.client_name,c.cost,c.image,c.status,c.date_added,cl.name As company_name, pl.name AS project_name ,u.full_name AS added_by,u.phone AS added_by_phone,c.client_phone,p.sales_phone,p.sales_name,p.commision,tl.name AS unit_type
   FROM closing_deals_management c 
   LEFT JOIN developers_management_langs cl ON c.company_id = cl.company_id AND cl.lang_code =:lang_code 
   LEFT JOIN projects_management p ON c.project_id = p.id
   LEFT JOIN projects_management_langs pl ON p.id = pl.project_id AND pl.lang_code = :lang_code 
   LEFT JOIN unit_types_langs tl ON c.unit_id = tl.unit_type_id AND tl.lang_code = :lang_code
   LEFT JOIN users u ON c.added_by = u.id 
   WHERE c.id = :id ";
   $stmt = $this->mDb->connect()->prepare($sql);
   $stmt->bindParam(':lang_code',$lang_code); 
   $stmt->bindParam(':id',$id);
   $stmt->execute();
   $data = $stmt->fetch(PDO::FETCH_ASSOC);

   return [
       'status' => 200,
       'data' => $data,
       'success' => true
   ];
}


} ?>