<?php
declare(strict_types=1);

require_once __DIR__ . '/vendor/autoload.php';

use Stride\Core\Bootstrap;
use Stride\Core\Response;

try {
    // Initialize application
    $app = Bootstrap::getInstance();
    
    // Get the requested endpoint
    $endpoint = $_GET['endpoint'] ?? '';
    if (empty($endpoint)) {
        Response::badRequest('No endpoint specified');
    }
    
    // Map endpoints to controller classes
    $routes = [
        'cities' => 'CitiesController',
        'users' => 'UsersController',
        'developers' => 'DevelopersController',
        'languages' => 'LanguagesController',
        'settings' => 'SettingsController',
        // Add other endpoints here
    ];
    
    // Check if endpoint exists
    if (!isset($routes[$endpoint])) {
        Response::notFound('Endpoint not found');
    }
    
    // Get controller class name
    $controllerClass = "\\Stride\\Controllers\\" . $routes[$endpoint];
    
    // Check if controller exists
    if (!class_exists($controllerClass)) {
        Response::error('Controller not found', 500);
    }
    
    // Create controller instance
    $controller = new $controllerClass();
    
    // Get action
    $action = $_GET['action'] ?? 'index';
    $method = $action . 'Action';
    
    // Check if action method exists
    if (!method_exists($controller, $method)) {
        Response::notFound('Action not found');
    }
    
    // Execute action
    $result = $controller->$method();
    
    // Send response
    Response::success($result);
    
} catch (\Throwable $e) {
    error_log($e->getMessage());
    Response::error('An error occurred', 500);
}
